REBOL [
	subject: "Gestionnaire d'cran"
	author: "Olivier Auverlot"
]

console: make object! [

	cursor: make object! [
		x: make integer! 1
		y: make integer! 1
	]


	Size: make object! [
        	width: make integer! 0
       		height: make integer! 0

	        getSize: function [] [ cons tmp ] [
        	        cons: open/no-wait/binary [ scheme: 'console ]
                	        prin "^(1B)[7n"
                        	tmp: next next to-string copy cons
	                close cons

        	        tmp: parse tmp ";"
                	height: to-integer (first tmp)
        	        width: to-integer to-string parse (second tmp) "R"
	        ]
	]       	    

	keyboard: make object! [
        	m_readKey: function [] [ cons c ] [
                	cons: open/no-wait/binary [ scheme: 'console ]
                        	if error? try [ c: first cons ] [ c: none ]
	                close cons
	                return c
	        ]

	        getKey: function [ /ascii /wait ] [ key buffer special-key sortie ] 
[
        	        either not wait [ sortie: true ] [ sortie: false ]
	                until [
	                        key: m_readKey
	                        either key <> none [
	                                buffer: make block! []
	                                either key <> #"^(1B)" [
	                                        switch/default key [
	                                                13 [ append buffer [ 1 
"ENTER" ] ]
	                                                9  [ append buffer [ 1 
"TAB"   ] ]
	                                                8  [ append buffer [ 1 
"DEL"   ] ]                                                      
	                                               
							127 [ append buffer [ 1 "DEL" ] ]	
	                                        ] [
	                                                either ascii [
	                                                        append buffer 0
	                                                        append buffer key
	                                                ] [ append buffer (to-char 
key)]
	                                                ]
	                                        return buffer
	                                ] [
	                                        until [
	                                                key: m_readKey
	                                                append buffer key
	                                                (key = none)
	                                        ]
	                                        special-key: make block! [1]
	                                        switch/default (second buffer) [
	                                                65 [ append special-key 
"UP" ]
	                                                66 [ append special-key 
"DOWN" ]
	                                                67 [ append special-key "RIGHT" ]
	                                                68 [ append special-key 
"LEFT" ]
	                                                50 [ append special-key 
"INSERT" ]
	                                                101 [ append special-key 
"END" ]
	                                        ] [ append special-key "UNKNOW" ]

        	                                return special-key
	                                ]
	                        ] [ if not wait [ return none ] ]
	                        (sortie = true)
	                ]
	        ]                                                                                                           
	]

	clear: function [] [] [ print "^(1B)[J" ]

	at: function [ x y /forget ] [] [
		if not forget [ 
			cursor/x: x
			cursor/y: y
		]
		prin join "^(1B)[" [ y ";" x "H" ]
	]

	hline: function [ x y width char ] [ ligne ] [
		ligne: copy ""
		loop width [ ligne: join ligne char ]
		at/forget x y 
		prin ligne
	]

	vline: function [ x y height char ] [] [
		loop height [ 
			at/forget x y
			prin char
			y: y + 1
		]
	]

	Box: function [ x y w h char1 /fill char2 ] [ tmp x2 y2 ] [
		either fill [
			tmp: copy char1	
			loop (w - 2) [
				tmp: append tmp char2
			]
			tmp: append tmp char1
			hline x y w char1
			hline x (y + h ) w char1
			y: y + 1
			loop (h - 1) [
				at/forget x y 
				prin tmp
				y: y + 1
			]
		] [
			x2: x + w - 1
			y2: y + h - 1
			hline x y w char1
			hline x y2 w char1
	 		vline x y h char1
			vline x2 y h char1
		]
	]

	frame: function [ x y w h /title titre /fill ] [ x2 y2 ] [
		x2: (x + w - 1)
		y2: (y + h - 1)
		hline x y w "-"
		hline x y2 w "-"
		vline x y h "|"
		vline x2 y h "|"

		at/forget x y prin "+"
		at/forget x y2 prin "+"
		at/forget x2 y prin "+"
		at/forget x2 y2 prin "+"

		if title [ at/forget (x + 2) y prin titre ]

		if fill [
			x: x + 1
			y: y + 1
			w: w - 2
			loop (h - 2) [
				hline x y w " "
				y: y + 1 
			]
			
		]
	]

]

